	org 64962
	; NOW FIXED HERE!

lefthi:		equ 65520	; POKE CODE L$(1) here - USR "T"
leftlo:		equ 65521	; POKE CODE L$(2) here - USR "T"+1
righthi:	equ 65522	; POKE CODE R$(1) here - USR "T"+2
rightlo:	equ 65523	; POKE CODE R$(2) here - USR "T"+3
outhi:		equ 65524	; H$(1)=CHR$(PEEK OUTHI) - USR "T"+4
outlo:		equ 65525	; H$(2)=CHR$(PEEK OUTLO) - USR "T"+5
key:		equ 65526	; key (0-15) for which bits to take - USR "T"+6
keycpl:		equ 65527	; 15-key, worked out in the initialisation phase - USR "T"+7


	; USR 64962 (variable MK): short routine to generate a new key after the end of the pyramid
	
	; OUTHI and OUTLO are set to the character codes of the two hex digits at the top
	; of the pyramid, so these have to be converted with ADJIN before the ANDs can happen.
	
	ld a,(outhi)	; OUTHI contains character code (0-9,A-F)
	call adjin	; OUTHI now contains a value 0-15 (highest 4 bits are all 0)
	and 3		; no need to shift bits, it stays as 0-15 for this process
	ld e,a
	ld a,(outlo)	; OUTLO contains character code (0-9,A-F)
	call adjin	; OUTHI now contains a value 0-15 (highest 4 bits are all 0)
	and 12
	add a,e
	ld (key),a
	ret

	; lookup table is from 64984 to 64999
keytable:
	defb 85,86,89,90,101,102,105,106,149,150,153,154,165,166,169,170

	; USR 65000 (variable MC) to execute the main routine

	; make sure both OUTHI and OUTLO are set to 0
	ld hl,outhi
	ld (hl),0
	ld hl,outlo
	ld (hl),0

	; POKE the value for KEY from BASIC into va+6
	; generate value for KEYCPL = 15-(KEY)
	; 0 is put into KEY for the first pass
	ld a,(key)
	cpl			; bottom 4 bits are what we want, but top 4 bits are all 1
	and 15			; top 4 bits are now 0 - this is the correct value
	ld (keycpl),a
	
	ld de,0	; need to make sure DE is clear

	; convert the character codes to the value (0-255) the two of them represent together
	ld a,(lefthi)	; LEFTHI contains character code (0-9,A-F)
	call adjin	; LEFTHI now contains a value 0-15 (highest 4 bits are all 0)
	and a		; clear carry flag just in case
	rla		; shift four bits left
	rla
	rla
	rla
	ld c,a		; move the result into C
	ld a,(leftlo)	; repeat the process for LEFTLO but don't shift it
	call adjin
	add a,c		; A now contains the value of the two-byte hex code held in L$

	; FOR A CLEAR EXPLANATION OF HOW THIS WORKS, i.e. step-by-step through
	; all the bit manipulation, see version 3.0 where there are no
	; CALLs or loops to confuse matters!

	; value from the above calculation must stay in A
	; value from KEYTABLE must end up in C

	push af	; stores the value of A on the stack
	ld a,(keycpl)	; need to convert the value at KEYCPL to the corresponding value in KEYTABLE
	ld c,a	; put that initial value into C
	pop af		; A now contains (again) the value of the two-byte hex code held in L$
	call bithacking
	; this gets half the bits into place

	; now do the process with the RIGHT value

	ld a,(righthi)	; repeat this whole process with RIGHTHI/RIGHTLO
	call adjin
	and a
	rla
	rla
	rla
	rla
	ld c,a
	ld a,(rightlo)
	call adjin
	add a,c		; A now contains the value of the two-byte hex code held in R$

	; value from the above calculation must stay in A
	; value from KEYTABLE must end up in C

	push af	; stores the value of A on the stack
	ld a,(key)	; need to convert the value at KEY to the corresponding value in KEYTABLE
	ld c,a	; put that initial value into C
	pop af		; A now contains (again) the value of the two-byte hex code held in L$
	call bithacking
	; this gets the other half of the bits into place
	
	; need to evaluate D OR E; old value of A is no longer needed
	ld a,d
	or e	; D OR E is now in A. Need to split to OUTHI and OUTLO.
	ld c,a	; store a copy of A in C
	and 15	; bottom four bits of A
	ld hl,outlo
	ld (hl),a	; OUTLO contains the value we want
	ld a,c	; retrieve original value of A from C
	and 240	; top four bits of A - carry is cleared by AND so no need to use SLA A
	rra
	rra
	rra
	rra
	dec hl	; HL now points to OUTHI
	ld (hl),a	; OUTHI contains the value we want
	
	; now, just need to adjust the values in OUTHI to their character codes

	ld a,(outhi)	; convert OUTHI from value to character code of the hex digit
	call adjout
	ld (outhi),a
	ld a,(outlo)	; convert OUTHI from value to character code of the hex digit
	call adjout
	ld (outlo),a
	ret		; and that's a wrap!



	; a subroutine where the bits are manipulated the way the ILLUMINATI want them to be
bithacking:
	ld hl,keytable	; point HL to KEYTABLE
	ld b,0
	add hl,bc
	ld c,(hl)	; C now contains the value from KEYTABLE
	and c		; A has now been reduced to the four bits we want
	; now need to get the bits where we want them...
	; A = (ab)(cd)(ef)(gh) - one of these bits in each pair will remain, the other will be 0
	; Each bit in each pair needs to be ORed with the other

	; need to do the following four times overall
	ld b,4
hackloop:	rlca	; shunt the top bit into carry
	rl d	; shunt the carry into D
	rlca	; shunt the top bit into carry
	rl e	; shunt the carry into E
	djnz hackloop
	ret


	; this bit won't need changing from V2

	; to take a character code stored in A (0-9 = 48-57, A-F = 65-70) and convert to its value (0-15):
adjin:	sub 48	; 0-9 are correct, A-F are 7 too high
	cp 10	; if A<10, carry flag is set...
	ret c	; ...so return immediately
	sub 7	; if A>=10, subtract the extra 7
	ret

	; to take a value stored in A (0-15) and convert to its character code (0-9 = 48-57, A-F = 65-70):
adjout:	add a,48	; 0-9 are correct (48-57), A-F are 7 too low (58-63)
	cp 58	; if A<58 (CODE "9"=57), carry flag is set...
	ret c	; ...so return immediately
	add a,7	; if A>=58 (CODE "A"=58 before this adjustment), add the extra 7
	ret


; 150 bytes for main routine
; 16 bytes for lookup table
; 22 bytes for new key routine


